﻿var card_index;
var ituSet = false;
var current_itu;
var language;
var auth_code_set = 0;
var ca_auth_set = 0;
var mux_auth_set = 0;
var authSetUnfold = false;
var nodeId;
var mainIPAddr;
var userName;
var oldHighLevel;
var modifyHighLevelFlag = false;

function mouseOverShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_hover.png)";
	}
}
function mouseOutShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_normal.png)";
	}
}
function ituChanged(obj)
{
	/*we need to warn the user that changing this setting will result in default*/
	/*values being used for many settings related to the RF ports*/
	var confirm_result;
	if(language == 0)
	{
		confirm_result = confirm("Changing the encoding type will cause the QAM to set default values for RF ports, QAM channels. The default values will be set once the apply button is clicked. Are you sure you would like to continue?");
	}
	else
	{
		confirm_result = confirm("改变编码模式会导致RF端口设置和频点设置自动改成默认值，点击设置按钮，默认值将会被立即设置，你确定要继续吗？");
	}
	
	if(confirm_result == true)
	{
	}
	else
	{
		obj.value = current_itu;
		return false;
	}
	ituSet = true;
	EnableApply();
}

/* function to get the card slot and status value*/
function GetCardInfo()
{
	var xmlhttp = false;
	var CardDisplay;
	var count = 0;
	var getParams = "type=3&cmd=1&card=" + card_index + "&language=" + language;

	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				CardDisplay = gb2utf8(xmlhttp.responseBody);
				var index = CardDisplay.indexOf("</html>");
				var bias = CardDisplay.length - index;
				CardDisplay = CardDisplay.slice(7, - bias).split("&");
			}
			else
			{
				CardDisplay = xmlhttp.responseText.slice(7, -8).split("&");
			}

			document.getElementById("card_no").innerHTML = CardDisplay[count++];
			document.getElementById("card_type").innerHTML = CardDisplay[count++];
			document.getElementById("card_name").value = CardDisplay[count++];
			document.getElementById("repel_network_twitter").value = CardDisplay[count++];
			current_itu = parseInt(CardDisplay[count++]);
			document.getElementById("annex_type").value = current_itu;
			oldHighLevel = CardDisplay[count++];
			document.getElementById("highLevel").value = oldHighLevel;
			document.getElementById("udpBackupEnabled").value = CardDisplay[count++];
			document.getElementById("udpChkTime").value = CardDisplay[count++];
			document.getElementById("udpRev2Prim").value = CardDisplay[count++];
			document.getElementById("udpRevChkTime").value = CardDisplay[count++];
			/*授权信息*/
			document.getElementById("authorization_code").value = CardDisplay[count++];
			document.getElementById("authority_limit").innerHTML = CardDisplay[count++];
			/*频点加扰授权信息*/
			document.getElementById("ca_auth_code").value = CardDisplay[count++];
			document.getElementById("ca_auth_limit").innerHTML = CardDisplay[count++];
			/*频点复用授权信息*/
			document.getElementById("mux_auth_code").value = CardDisplay[count++];
			document.getElementById("mux_auth_limit").innerHTML = CardDisplay[count++];
			var curCardType = parseInt(CardDisplay[count++]);
			if(curCardType == 3016)
			{
				$("#highLevelTr").show();
			}
			else
			{
				$("#highLevelTr").hide();
			}

			document.body.style.cursor = "auto";
			window.status = "Done";
		}
	}
	xmlhttp.send(getParams);
	return false;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	DisableApply();
	DisableAuthApply();
	disabledButton(document.getElementById("scrambleAuthApply"), true);
	disabledButton(document.getElementById("multiAuthApply"), true);
	GetCardInfo();
	ituSet = false;
	auth_code_set = 0;
	ca_auth_set = 0;
	mux_auth_set = 0;
	authSetUnfold = false;
}

function pageRefresh()
{
	PageLoadHandler();
}

var deviceType;
var QAM = 1;
var TYPE_518B = 2;
//查询当前设备类型
function queryDeviceType()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=54&cmd=1&ran=" + Math.random();

	xmlhttp.open("GET", "/goform/formIPQAM?" + getParams, true);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			deviceType = xmlhttp.responseText.slice(7, -8);			
			initDeviceRelationParam();
		}
	}
	xmlhttp.send(null);
	return true;
}

//初始化和设备类型相关的参数
function initDeviceRelationParam()
{
	if(deviceType == TYPE_518B)
	{
		$("#caAuthDiv").hide();
		$("#multiplexAuthDiv").hide();
		var optionStr = '<option value="0">ATSC-A/53</option>';
	}
	else
	{
		$("#multiplexAuthDiv").show();
		if(deviceType == QAM)
		{
			$("#caAuthDiv").hide();
		}
		else
		{
			$("#caAuthDiv").show();
		}
		var optionStr = '<option value="0">ITU-A</option>';
		  optionStr  += '<option value="1">ITU-B</option>';
		  optionStr  += '<option value="2">ITU-C</option>';
	}
	$("#annex_type").empty();
	$("#annex_type").append(optionStr);
}
window.onload = function()
{
	queryDeviceType();
	var args = getArgs();
	nodeId = args["nodeId"];
	mainIPAddr = args["mainIPAddr"];
	var group = args["group"];
	userName = args["userName"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	card_index = parseInt(nodeId);
	language = document.getElementById("language").value;
	var apply = document.getElementById("Apply");
	var CardReset = document.getElementById("CardReset");
	var AuthSet = document.getElementById("AuthDisplay");
	applyDispay(group, apply);
	//adminDisplay(group, CardReset);
	adminDisplay(group, AuthSet);
	PageLoadHandler();
    document.getElementById("AuthSectionDiv").style.display = "none";
	$("#highLevel").change(function()
	{
		if(oldHighLevel != $(this).val())
		{
			modifyHighLevelFlag = true;
		}
		else
		{
			modifyHighLevelFlag = false;
		}
	/*if(modifyHighLevelFlag)
		{
			var confirm_result;
			if(language == 0)
			{
				confirm_result = confirm("Change of high level will take effect after rebooting the card. Continue?");
			}
			else
			{
				confirm_result = confirm("高电平的改变，需要重启后方可生效，你确定要继续吗？");
			}
		}*/
		//if(confirm_result == true)
		//{
			EnableApply();
		//}
	//	else
		//{
		//	$(this).val(oldHighLevel);
		//}		
	});
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function DisableAuthApply()
{
	disabledButton(document.getElementById("authApply"), true);
}

function EnableAuthApply()
{
	disabledButton(document.getElementById("authApply"), false);
}

function EnableScrambleAuth()
{
	disabledButton(document.getElementById("scrambleAuthApply"), false);
}
function EnableMultiAuth()
{
	disabledButton(document.getElementById("multiAuthApply"), false);
}
function CheckCardName(comp)
{
	var CardName = comp.value;
	if(validateName(CardName, 0, language) != true)
	{
		setTimeout(function () {comp.focus()}, 50);
		comp.select();
		return false;
	}
	return true;
}

function CheckNetwork(comp)
{
	if(validateNumber(comp.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Resistance network jitter.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的抗网络抖动时间。");
		}
		setTimeout(function () {comp.focus()}, 50);
		comp.select();
		return false;
	}

	if((comp.value < 1) || (comp.value > 1000))
	{
		if(language == 0)
		{
			alert("Valid range for Resistance network jitter is 1 - 1000."); 
		}
		else
		{
			alert("抗网络抖动时间的范围是1 - 1000。"); 
		}
		setTimeout(function () {comp.focus()}, 50);
		comp.select();
		return false;
	}
	return true;  
}

function validateAllInput()
{
	var comp;
	comp = document.getElementById("card_name");
	if(CheckCardName(comp) == false)
	{
		return false;
	}
		
	comp = document.getElementById("repel_network_twitter");
	if(CheckNetwork(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("udpChkTime");
	if(CheckTime(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("udpRevChkTime");
	if(CheckTime(comp) == false)
	{
	  return false;
	}
	if((authSetUnfold == true) && (auth_code_set == 1))
	{
		comp = document.getElementById("authorization_code");
		if(!checkAuthCode(comp))
		{
			return false;
		}
	}
	
	if((authSetUnfold == true) && (ca_auth_set == 1))
	{
		comp = document.getElementById("ca_auth_code");
		if(!checkAuthCode(comp))
		{
			return false;
		}
	}
	if((authSetUnfold == true) && (mux_auth_set == 1))
	{
		comp = document.getElementById("mux_auth_code");
		if(!checkAuthCode(comp))
		{
			return false;
		}
	}
	return true;
}

function setAnnexType()
{
	var getParams = "type=3&cmd=2&userName=" + userName + "&card=" + card_index;
	
	var annex_type = document.getElementById("annex_type").value;
	getParams = getParams + "&" + "annex_type=" + annex_type;
	
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true)
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Card configuration updated successfully.");
			}
			else
			{
				alert("卡参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetCardInfo()
{
	var refreshTree = false;
	var getParams = "type=3&cmd=2&userName=" + userName + "&card=" + card_index;
	
	var card_name = document.getElementById("card_name").value;
	getParams = getParams + "&card_name=" + card_name;
		
	var repel_network_twitter = document.getElementById("repel_network_twitter").value;
	getParams = getParams + "&repel_network_twitter=" + repel_network_twitter;
	
	var high_level = document.getElementById("highLevel").value;
	getParams = getParams + "&high_level=" + high_level;	
	
	var udpBackupEnabled = document.getElementById("udpBackupEnabled").value;
	getParams = getParams + "&udpBackupEnabled=" + udpBackupEnabled;
	
	var udpChkTime = document.getElementById("udpChkTime").value;
	getParams = getParams + "&udpChkTime=" + udpChkTime;
	
	var udpRev2Prim = document.getElementById("udpRev2Prim").value;
	getParams = getParams + "&udpRev2Prim=" + udpRev2Prim;
	
	var udpRevChkTime = document.getElementById("udpRevChkTime").value;
	getParams = getParams + "&udpRevChkTime=" + udpRevChkTime;

	if((authSetUnfold == true) && (auth_code_set == 1))
	{
		var authorization_code = document.getElementById("authorization_code").value;
		getParams = getParams + "&authorization_code=" + authorization_code;
		refreshTree = true;
	}
		
	if((authSetUnfold == true) && (ca_auth_set == 1))
	{
		var ca_auth_code = document.getElementById("ca_auth_code").value;
		getParams = getParams + "&ca_auth_code=" + ca_auth_code;
		refreshTree = true;
	}
	if((authSetUnfold == true) && (mux_auth_set == 1))
	{
		var mux_auth_code = document.getElementById("mux_auth_code").value;
		getParams = getParams + "&mux_auth_code=" + mux_auth_code;
		refreshTree = true;
	}
	
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(ituSet == true)
			{
				setAnnexType();
			}
			else
			{
				var url;
				if(language == 0)
				{
					alert("Card configuration updated successfully.");
					url = "http://" + mainIPAddr + "/asp/main.asp?nodeId=" + nodeId;
				}
				else
				{
					alert("卡参数设置成功。");
					url = "http://" + mainIPAddr + "/asp/main_cn.asp?nodeId=" + nodeId;
				}
				if($("#highLevel").val() != oldHighLevel)
				{
					if(language == 0)
					{
						alert("Change of high level will take effect after rebooting the card!");
					}
					else
					{
						alert("高电平的改变，需要重启后方可生效！");
					}
				}
				if(refreshTree == true)
				{
					window.parent.location.replace(url);
				}
				else
				{
					PageLoadHandler();
				}
			}
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetCardConfiguration()
{
	if(!validateAllInput())
	{
		return false;
	}
	
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating card information, please wait...";
	SetCardInfo();		
}

function CardReset()
{
	
}

/*只能输入由数字和26个英文字母组成的32个字符的字符串*/
function checkAuthCode(comp)
{	
	var AuthCode = comp.value;
	var patrn = /^[A-Za-z0-9]{32}$/;  
	if(!patrn.exec(AuthCode)) 
	{
		if(language == 0)
		{
			alert("Authorized code should consist of 32 chars(only integer or letter).");
		}
		else
		{
			alert("授权码应由32位数字或字母组成。");
		}
		setTimeout(function () {comp.focus()}, 50);
		comp.select();
		return false; 
	}
	
	if(comp.id == "authorization_code")
	{
		EnableAuthApply();
		auth_code_set = 1;
	}
	else if(comp.id == "ca_auth_code")
	{
		EnableScrambleAuth();
		ca_auth_set = 1;
	}
	else
	{
		EnableMultiAuth();
		mux_auth_set = 1;
	}
	return true;
}

function SetAuthCode()
{
	DisableAuthApply();
	document.body.style.cursor = "wait";
	window.status = "Updating card information, please wait...";

	var getParams = "type=3&cmd=2&userName=" + userName + "&card=" + card_index;
	if(auth_code_set == 1)
	{
		var authorization_code = document.getElementById("authorization_code").value;
		getParams = getParams + "&authorization_code=" + authorization_code;
	}
	
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var url;
			if(language == 0)
			{
				alert("Card authorization code updated successfully.");
				url = "http://" + mainIPAddr + "/asp/main.asp?nodeId=" + nodeId;
			}
			else
			{
				alert("卡授权参数已设置成功。");
				url = "http://" + mainIPAddr + "/asp/main_cn.asp?nodeId=" + nodeId;
			}
			window.parent.location.replace(url);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetScrambleAuthCode()
{
	disabledButton(document.getElementById("scrambleAuthApply"), true);
	
	var xmlhttp = getHTTPObject();
	var getParams = "type=3&cmd=2&card=" + card_index;
	if(ca_auth_set == 1)
	{
		var ca_auth_code = document.getElementById("ca_auth_code").value;
		getParams = getParams + "&ca_auth_code=" + ca_auth_code;
	}
	
	document.body.style.cursor = "wait";
	window.status = "Updating card information, please wait...";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var url;
			if(language == 0)
			{
				alert("Channel AC authorization code updated successfully.");
				url = "http://" + mainIPAddr + "/asp/main.asp?nodeId=" + nodeId;
			}
			else
			{
				alert("频点加扰授权参数已设置成功。");
				url = "http://" + mainIPAddr + "/asp/main_cn.asp?nodeId=" + nodeId;
			}
			window.parent.location.replace(url);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetMultiAuthCode()
{
	disabledButton(document.getElementById("multiAuthApply"), true);
	
	var xmlhttp = getHTTPObject();
	var getParams = "type=3&cmd=2&card=" + card_index;
	if(mux_auth_set == 1)
	{
		var mux_auth_code = document.getElementById("mux_auth_code").value;
		getParams = getParams + "&mux_auth_code=" + mux_auth_code;
	}
	
	document.body.style.cursor = "wait";
	window.status = "Updating card information, please wait...";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var url;
			if(language == 0)
			{
				alert("Channel Multiplex authorization code updated successfully.");
				url = "http://" + mainIPAddr + "/asp/main.asp?nodeId=" + nodeId;
			}
			else
			{
				alert("频点复用授权参数已设置成功。");
				url = "http://" + mainIPAddr + "/asp/main_cn.asp?nodeId=" + nodeId;
			}
			window.parent.location.replace(url);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function MM_showHideLayers() 
{ 
	var d, v; 
	var but = document.getElementById("AuthDisplay");

	if(language == 0)
	{
		if(but.value == "Hide Authority Settings")
		{
			but.value = "Show Authority Settings";
			d = "none";
			authSetUnfold = false;
		}
		else
		{
			but.value = "Hide Authority Settings"; 
			d = "";
			authSetUnfold = true;
		}
	}
	else
	{
		if(but.value == "隐藏授权设置")
		{
			but.value = "显示授权设置";
			d = "none";
			authSetUnfold = false;
		}
		else
		{
			but.value = "隐藏授权设置"; 
			d = "";
			authSetUnfold = true;
		}
	}
	
    document.getElementById("AuthSectionDiv").style.display = d;
}
function CheckBackupEnabled(comp)
{
	if(comp.value == 0)//Disabled
	{
		document.getElementById("udpChkTime").disabled = true;
	}
	else
	{
		document.getElementById("udpChkTime").disabled = false;
	}
}

function CheckRev2Primary(comp)
{
	if(comp.value == 0)//Disabled
	{
		document.getElementById("udpRevChkTime").disabled = true;
	}
	else
	{
		document.getElementById("udpRevChkTime").disabled = false;
	}
}
function CheckTime(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Check Time.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的切换时间。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 999))
	{
		if(language == 0)
		{
			alert("Valid range for Check Time is 0 - 999.");
		}
		else
		{
			alert("切换时间的范围是0 - 999。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}